/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl.structure;

import java.util.Collection;
import java.util.Map;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;

public class ForeignKey<T extends Table<T>, U extends Table<U>, ID>
implements Key<T, ID> {
    private final T table;
    private final String name;
    private final KeepOrderMap<Column<T, Object>, Column<U, Object>> columns;
    private final U targetTable;

    public <I> ForeignKey(String name, Column<T, I> column, Column<U, I> targetColumn) {
        this(name, new KeepOrderSet(new Object[]{column}), new KeepOrderSet(new Object[]{targetColumn}));
    }

    public ForeignKey(String name, KeepOrderSet<? extends Column<T, Object>> columns, KeepOrderSet<? extends Column<U, Object>> targetColumns) {
        this(name, (KeepOrderMap)Iterables.pair(columns, targetColumns, KeepOrderMap::new));
    }

    public ForeignKey(String name, KeepOrderMap<? extends Column<T, Object>, ? extends Column<U, Object>> columns) {
        Map.Entry firstEntry = (Map.Entry)Iterables.first((Iterable)columns.entrySet());
        this.table = ((Column)firstEntry.getKey()).getTable();
        this.targetTable = ((Column)firstEntry.getValue()).getTable();
        this.name = name;
        this.columns = columns;
    }

    @Override
    public KeepOrderSet<Column<T, Object>> getColumns() {
        return new KeepOrderSet((Collection)this.columns.keySet());
    }

    @Override
    public boolean isComposed() {
        return this.columns.size() > 1;
    }

    public String getName() {
        return this.name;
    }

    public KeepOrderSet<Column<U, Object>> getTargetColumns() {
        return new KeepOrderSet(this.columns.values());
    }

    @Override
    public T getTable() {
        return this.table;
    }

    public U getTargetTable() {
        return this.targetTable;
    }
}

